
import gurobipy as gp

# Create a new model
model = gp.Model("Sausage_Burger_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Sausages")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Burger_Patties")

# Set objective function
model.setObjective(200*x + 250*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + 4*y <= 3000, "Meat_Grinder_Constraint")
model.addConstr(3*x + 1.5*y <= 3000, "Meat_Packer_Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Sausages: {x.x}")
    print(f"  Burger Patties: {y.x}")
    print(f"  Max Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

