
from gurobipy import *

# Create a model
m = Model("Sausage_and_Burger_Patty_Production")

# Define variables
x_s = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sausages")
x_b = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="burger_patties")

# Set objective function
m.setObjective(200*x_s + 250*x_b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x_s + 4*x_b <= 3000, "meat_grinder_constraint")
m.addConstr(3*x_s + 1.5*x_b <= 3000, "meat_packer_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of batches of sausages: {x_s.x}")
    print(f"Number of batches of burger patties: {x_b.x}")
    print(f"Total profit: ${200*x_s.x + 250*x_b.x:.2f}")
else:
    print("No optimal solution found")
