
import gurobipy as gp

# Create a new model
m = gp.Model("Sausage_Burger_Optimization")

# Define decision variables
x_s = m.addVar(name="x_s", lb=0, ub=None, obj=200)  # batches of sausages
x_b = m.addVar(name="x_b", lb=0, ub=None, obj=250)  # batches of burger patties

# Meat-grinder constraint
m.addConstr(2 * x_s + 4 * x_b <= 3000, name="meat_grinder")

# Meat-packer constraint
m.addConstr(3 * x_s + 1.5 * x_b <= 3000, name="meat_packer")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GUROBI_OPTIMAL:
    print("Optimal solution found.")
    print(f"Batches of sausages: {x_s.varValue}")
    print(f"Batches of burger patties: {x_b.varValue}")
    print(f"Max profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
