
import gurobipy as gp

# Create a new model
m = gp.Model("brunch_optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="eggs_benedict")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hashbrowns")

# Set the objective function
m.setObjective(4*x + 2*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 5*y <= 5000, "butter_constraint")
m.addConstr(x + 2*y <= 600, "egg_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Eggs Benedict: {x.x}")
    print(f"Number of Hashbrowns: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

