
from gurobipy import *

# Create a new model
model = Model("Brunch_Optimization")

# Define the decision variables
x1 = model.addVar(name="eggs_benedict", vtype=GRB.CONTINUOUS, lb=0)
x2 = model.addVar(name="hashbrown", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
model.setObjective(4*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x1 + 5*x2 <= 5000, name="butter_constraint")
model.addConstr(x1 + 2*x2 <= 600, name="egg_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eggs Benedicts to make: {x1.x}")
    print(f"Hashbrowns to make: {x2.x}")
    print(f"Total Profit: ${model.objVal}")
else:
    print("No optimal solution found")
