
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="eggs_benedicts")  # Number of eggs benedicts
    y = model.addVar(lb=0, name="hashbrowns")  # Number of hashbrowns

    # Define the objective function (maximize profit)
    model.setObjective(4 * x + 2 * y, gurobi.GRB.MAXIMIZE)

    # Add butter constraint
    model.addConstr(10 * x + 5 * y <= 5000, name="butter_constraint")

    # Add egg constraint
    model.addConstr(x + 2 * y <= 600, name="egg_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: eggs benedicts = {x.varValue}, hashbrowns = {y.varValue}")
        print(f"Maximal profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization problem
solve_optimization_problem()
