
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("PopcornMix")

# Create decision variables
x = m.addVar(lb=0, name="SweetMix")  # Pounds of sweet mix
y = m.addVar(lb=0, name="RegularMix") # Pounds of regular mix

# Set objective function
m.setObjective(3*x + 2*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.25*x + 0.50*y <= 30, "ButterConstraint")
m.addConstr(0.75*x + 0.50*y <= 40, "CaramelConstraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Sweet Mix: {x.x:.2f} pounds")
    print(f"Regular Mix: {y.x:.2f} pounds")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

