
from gurobipy import *

# Create a new model
m = Model("popcorn_optimization")

# Define the decision variables
x_s = m.addVar(name="sweet_mix", lb=0)
x_r = m.addVar(name="regular_mix", lb=0)

# Set the objective function to maximize profit
m.setObjective(3*x_s + 2*x_r, GRB.MAXIMIZE)

# Add constraints based on caramel and butter popcorn availability
m.addConstr(0.75*x_s + 0.5*x_r <= 40, name="caramel_constraint")
m.addConstr(0.25*x_s + 0.5*x_r <= 30, name="butter_constraint")

# Optimize the model
m.optimize()

# Print out the results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sweet mix: {x_s.x} pounds")
    print(f"Regular mix: {x_r.x} pounds")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found.")
