
import gurobi

def solve_popcorn_mix_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x = m.addVar(name="Sweet_Mix", lb=0)  # Pounds of sweet mix
    y = m.addVar(name="Regular_Mix", lb=0)  # Pounds of regular mix

    # Objective function: Maximize profit
    m.setObjective(3*x + 2*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(0.25*x + 0.50*y <= 30, name="Butter_Popcorn_Constraint")
    m.addConstr(0.75*x + 0.50*y <= 40, name="Caramel_Popcorn_Constraint")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Sweet Mix: {x.varValue} pounds")
        print(f"Regular Mix: {y.varValue} pounds")
        print(f"Max Profit: ${m.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_popcorn_mix_problem()
