
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("Boarstone_Machines")

    # Create variables
    x = m.addVar(vtype=GRB.INTEGER, name="regular_machines")
    y = m.addVar(vtype=GRB.INTEGER, name="advanced_machines")

    # Set objective function
    m.setObjective(1000*x + 10000*y, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5*x + 25*y >= 120, "task_completion")
    m.addConstr(2*x + 5*y <= 20, "worker_limit")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"Number of regular machines (x): {x.x}")
        print(f"Number of advanced machines (y): {y.x}")
        print(f"Minimum cost: ${m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
