
from gurobipy import *

# Create a model
m = Model("Boarstone_Factory_Optimization")

# Decision variables
x = m.addVar(name='regular_machines', vtype=GRB.INTEGER, lb=0)
y = m.addVar(name='advanced_machines', vtype=GRB.INTEGER, lb=0)

# Objective function: Minimize cost
m.setObjective(1000*x + 10000*y, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x + 25*y >= 120, name='task_requirement')
m.addConstr(2*x + 5*y <= 20, name='worker_limitation')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x.varName} = {x.x}, {y.varName} = {y.x}")
else:
    print("No optimal solution found")

