
import gurobi

def solve_boarstone_factory_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Regular_Machines")
    A = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Advanced_Machines")

    # Objective function: Minimize cost
    model.setObjective(1000*R + 10000*A, gurobi.GRB.MINIMIZE)

    # Tasks per hour constraint
    model.addConstr(5*R + 25*A >= 120, name="Tasks_Constraint")

    # Worker constraint
    model.addConstr(2*R + 5*A <= 20, name="Workers_Constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Regular Machines: {R.varValue}")
        print(f"Advanced Machines: {A.varValue}")
        print(f"Total Cost: ${model.objVal}")
    else:
        print("The model is infeasible.")

solve_boarstone_factory_problem()
