
import gurobipy as gp

# Create a new model
model = gp.Model("FancyClothing")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="red_shirts")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_shirts")

# Set objective function
model.setObjective(20 * x + 35 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * x + 5 * y <= 1500, "dye_constraint")
model.addConstr(5 * x + 8 * y <= 3000, "water_constraint")
model.addConstr(20 * x + 25 * y <= 8000, "worker_minutes_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Red Shirts: {x.x}")
    print(f"Green Shirts: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

