
from gurobipy import *

# Create a new model
m = Model("Fancy_Clothing_Co")

# Define decision variables
x_r = m.addVar(vtype=GRB.CONTINUOUS, name="red_shirts", lb=0)
x_g = m.addVar(vtype=GRB.CONTINUOUS, name="green_shirts", lb=0)

# Objective function: Maximize profit
m.setObjective(20*x_r + 35*x_g, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x_r + 5*x_g <= 1500, "dye_constraint")
m.addConstr(5*x_r + 8*x_g <= 3000, "water_constraint")
m.addConstr(20*x_r + 25*x_g <= 8000, "worker_minutes_constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x_r.x:.2f} red shirts and {x_g.x:.2f} green shirts.")
else:
    print("No optimal solution found")
