
import gurobi

def solve_fancy_clothing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=0, name="RedShirts")
    G = model.addVar(lb=0, name="GreenShirts")

    # Objective function: Maximize profit
    model.setObjective(20*R + 35*G, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*R + 5*G <= 1500, name="DyeConstraint")
    model.addConstr(5*R + 8*G <= 3000, name="WaterConstraint")
    model.addConstr(20*R + 25*G <= 8000, name="WorkerMinutesConstraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Red shirts: {R.varValue}, Green shirts: {G.varValue}")
        print(f"Max Profit: ${20*R.varValue + 35*G.varValue}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_fancy_clothing_problem()
