
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Miniature_Animals")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="Mini_Bears")  # Number of mini bears
y = m.addVar(vtype=GRB.INTEGER, name="Mini_Dogs")  # Number of mini dogs

# Set objective function
m.setObjective(40*x + 47*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x + 7*y <= 400, "Cotton_Constraint")
m.addConstr(x + y <= 40, "Production_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Mini Bears: {x.x}")
    print(f"Number of Mini Dogs: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

