
from gurobipy import *

# Create a new model
m = Model("artist_profit")

# Define variables
x = m.addVar(lb=0, name="mini_bears")
y = m.addVar(lb=0, name="mini_dogs")

# Objective function: Maximize profit
m.setObjective(40*x + 47*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(8*x + 7*y <= 400, "cotton_availability")
m.addConstr(x + y <= 40, "total_animals")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mini bears: {x.x}")
    print(f"Mini dogs: {y.x}")
    print(f"Total profit: ${40*x.x + 47*y.x:.2f}")
else:
    print("No optimal solution found")
