
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Nut_Combo_Optimization")

# Create decision variables
x = model.addVar(lb=0, name="x") # Kilograms of Combo X
y = model.addVar(lb=0, name="y") # Kilograms of Combo Y

# Set objective function
model.setObjective(35*x + 55*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.7*x + 0.35*y <= 35, "Almond_Constraint")
model.addConstr(0.3*x + 0.65*y <= 20, "Hazelnut_Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Kilograms of Combo X: {x.x}")
    print(f"Kilograms of Combo Y: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

