
from gurobipy import *

# Create a model
m = Model("Nut_Combo_Optimization")

# Define the decision variables
x = m.addVar(lb=0, name="Combo_X")  # Amount of Combo X to produce
y = m.addVar(lb=0, name="Combo_Y")  # Amount of Combo Y to produce

# Set the objective function: Maximize profit
m.setObjective(35*x + 55*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*x + 0.35*y <= 35, "Almond_Constraint")
m.addConstr(0.3*x + 0.65*y <= 20, "Hazelnut_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x.x:.2f} kg of Combo X and {y.x:.2f} kg of Combo Y.")
else:
    print("No optimal solution found. The problem might be infeasible.")

