
import gurobi

def solve_alpha_nut_problem():
    model = gurobi.Model()

    x = model.addVar(name="Combo_X", lb=0, obj=35)  
    y = model.addVar(name="Combo_Y", lb=0, obj=55)  

    almonds_constraint = model.addConstr(0.70 * x + 0.35 * y <= 35, name="almonds_constraint")
    hazelnuts_constraint = model.addConstr(0.30 * x + 0.65 * y <= 20, name="hazelnuts_constraint")

    model.setObjective(x.obj + y.obj, gurobi.GRB.MAXIMIZE)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of Combo X: {x.x}")
        print(f"Optimal amount of Combo Y: {y.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_alpha_nut_problem()
