
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fruit_investment")

# Create variables
x1 = m.addVar(lb=0, name="apple")
x2 = m.addVar(lb=0, name="orange")
x3 = m.addVar(lb=0, name="pear")
x4 = m.addVar(lb=0, name="banana")

# Set objective function
m.setObjective(0.05 * x1 + 0.06 * x2 + 0.03 * x3 + 0.08 * x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 300000, "budget")
m.addConstr(x4 <= x1, "banana_limit")
m.addConstr(x2 <= x3, "orange_limit")
m.addConstr(0.7 * x4 <= 0.3 * (x1 + x2 + x3), "banana_proportion")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in Apple: ${x1.x:.2f}")
    print(f"Invest in Orange: ${x2.x:.2f}")
    print(f"Invest in Pear: ${x3.x:.2f}")
    print(f"Invest in Banana: ${x4.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

