
from gurobipy import *

# Create a new model
m = Model("Fruit_Investment")

# Define the decision variables
A = m.addVar(name="Apple", lb=0)
O = m.addVar(name="Orange", lb=0)
P = m.addVar(name="Pear", lb=0)
B = m.addVar(name="Banana", lb=0)

# Objective function: Maximize return
m.setObjective(0.05*A + 0.06*O + 0.03*P + 0.08*B, GRB.MAXIMIZE)

# Constraints
m.addConstr(A + O + P + B <= 300000, name="Total_Investment")
m.addConstr(B <= A, name="Banana_vs_Apple")
m.addConstr(O <= P, name="Orange_vs_Pear")
m.addConstr(B <= 0.3*(A + O + P + B), name="Max_Banana_Percentage")

# Solve the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
