
import gurobi

def solve_investment_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    A = model.addVar(name="Apple", lb=0)
    O = model.addVar(name="Orange", lb=0)
    P = model.addVar(name="Pear", lb=0)
    B = model.addVar(name="Banana", lb=0)

    # Objective function: maximize return on investment
    model.setObjective(0.05 * A + 0.06 * O + 0.03 * P + 0.08 * B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B <= A, name="Banana_Apple")
    model.addConstr(O <= P, name="Orange_Pear")
    model.addConstr(B <= 90000, name="Banana_Limit")
    model.addConstr(A + O + P + B <= 300000, name="Total_Investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Apple: ${A.varValue:.2f}")
        print(f"Orange: ${O.varValue:.2f}")
        print(f"Pear: ${P.varValue:.2f}")
        print(f"Banana: ${B.varValue:.2f}")
        print(f"Total return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
