
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("TV_Commercials")

# Define decision variables
movies = model.addVar(vtype=GRB.INTEGER, name="movies")
sports = model.addVar(vtype=GRB.INTEGER, name="sports")
comedy = model.addVar(vtype=GRB.INTEGER, name="comedy")

# Set objective function: Maximize audience reach
model.setObjective(25000 * movies + 100000 * sports + 45000 * comedy, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1000 * movies + 5000 * sports + 2000 * comedy <= 50000, "Budget")  # Budget constraint
model.addConstr(sports <= 5, "Sports_Limit")  # Sports commercials limit
model.addConstr(comedy <= (movies + sports + comedy) / 3, "Comedy_Proportion")  # Comedy proportion constraint
model.addConstr(movies >= 0.15 * (movies + sports + comedy), "Movies_Proportion")  # Movies proportion constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of movie commercials: {movies.x}")
    print(f"Number of sports commercials: {sports.x}")
    print(f"Number of comedy commercials: {comedy.x}")
    print(f"Total audience reach: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

