
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("TV_Commercial_Optimization")

# Decision variables
M = model.addVar(lb=0, vtype=GRB.INTEGER, name="Movies")
S = model.addVar(lb=0, vtype=GRB.INTEGER, name="Sports")
C = model.addVar(lb=0, vtype=GRB.INTEGER, name="Comedy")

# Objective function: Maximize audience reach
model.setObjective(25000*M + 100000*S + 45000*C, GRB.MAXIMIZE)

# Budget constraint
model.addConstr(1000*M + 5000*S + 2000*C <= 50000, name="Budget")

# Sports games constraint
model.addConstr(S <= 5, name="Sports_Limit")

# Comedy shows constraint
model.addConstr(C <= (M + S + C)/3, name="Comedy_Limit")

# Movies constraint
model.addConstr(M >= 0.15*(M + S + C), name="Movie_Minimum")

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Movies: {M.varValue}")
    print(f"Sports: {S.varValue}")
    print(f"Comedy: {C.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
