
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("candy_mix")

    # Create variables
    x = m.addVar(vtype=GRB.INTEGER, name="sour_cherry") # Integer since you can't have fractions of candies.
    y = m.addVar(vtype=GRB.INTEGER, name="sour_peach")

    # Set objective
    m.setObjective(0.10 * x + 0.12 * y, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * x + y >= 50, "citric_acid")
    m.addConstr(3 * x + 4 * y >= 60, "sugar")
    m.addConstr(x <= 10, "cherry_limit")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Number of sour cherry candies (x): {x.x}")
        print(f"Number of sour peach candies (y): {y.x}")
        print(f"Minimum Cost: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
