
from gurobipy import *

# Create a new model
m = Model("Candy_Mix")

# Define the decision variables
x_c = m.addVar(lb=0, name="sour_cherry_candies")
x_p = m.addVar(lb=0, name="sour_peach_candies")

# Set the objective function to minimize costs
m.setObjective(0.10*x_c + 0.12*x_p, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x_c + x_p >= 50, name="citric_acid_constraint")
m.addConstr(3*x_c + 4*x_p >= 60, name="sugar_constraint")
m.addConstr(x_c <= 10, name="sour_cherry_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sour Cherry Candies: {x_c.x}")
    print(f"Sour Peach Candies: {x_p.x}")
    print(f"Total Cost: ${0.10*x_c.x + 0.12*x_p.x:.2f}")
else:
    print("No optimal solution found")
