
import gurobi

def solve_candy_mix():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, ub=10, vtype=gurobi.GRB.INTEGER, name="sour_cherry_candies")
    y = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="sour_peach_candies")

    # Objective function: Minimize cost
    model.setObjective(0.10 * x + 0.12 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x + y >= 50, name="citric_acid_requirement")
    model.addConstr(3 * x + 4 * y >= 60, name="sugar_requirement")
    model.addConstr(x <= 10, name="sour_cherry_limit")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_candy_mix()
