
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("sports_warehouse")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="hockey_nets")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="basketball_hoops")

# Set objective function
m.setObjective(50*x + 75*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 3*y <= 300, "space_constraint")
m.addConstr(100*x + 150*y <= 10000, "budget_constraint")
m.addConstr(x >= 0.65 * (x + y), "hockey_proportion")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Hockey Nets (x): {x.x}")
    print(f"Number of Basketball Hoops (y): {y.x}")
    print(f"Optimal Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

