
from gurobipy import *

# Create a model
m = Model("Sports Warehouse Optimization")

# Define the decision variables
H = m.addVar(vtype=GRB.INTEGER, name="hockey_nets")
B = m.addVar(vtype=GRB.INTEGER, name="basketball_hoops")

# Objective function: Maximize profit
m.setObjective(50*H + 75*B, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*H + 3*B <= 300, "space_constraint")
m.addConstr(100*H + 150*B <= 10000, "budget_constraint")
m.addConstr(H >= 0.65*(H + B), "percentage_hockey_nets")

# Solve the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Buy {H.x} hockey nets and {B.x} basketball hoops")
    print(f"Maximum profit: ${50*H.x + 75*B.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
