
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(name="x", obj=50, vtype=gurobi.GRB.INTEGER)  # number of hockey nets
    y = model.addVar(name="y", obj=75, vtype=gurobi.GRB.INTEGER)  # number of basketball hoops

    # Space constraint
    model.addConstr(5 * x + 3 * y <= 300, name="space_constraint")

    # Budget constraint
    model.addConstr(100 * x + 150 * y <= 10000, name="budget_constraint")

    # Product mix constraint
    model.addConstr(x >= 1.8571 * y, name="product_mix_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue:.0f}, y = {y.varValue:.0f}")
        print(f"Maximum profit: ${50 * x.varValue + 75 * y.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
