
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("lab_staffing")

    # Create variables
    x = m.addVar(lb=0, vtype=GRB.INTEGER, name="undergraduates") # Integer number of undergraduates
    y = m.addVar(lb=0, vtype=GRB.INTEGER, name="graduates") # Integer number of graduates

    # Set objective function
    m.setObjective(100*x + 300*y, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(x + y >= 50, "total_students")
    m.addConstr(y >= 10, "min_graduates")
    m.addConstr(y >= (1/3)*x, "graduate_proportion")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Number of Undergraduates (x): {x.x}")
        print(f"Number of Graduates (y): {y.x}")
        print(f"Minimum Weekly Wage: ${m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
