
from gurobipy import *

# Create a new model
m = Model("ResearchLab")

# Define the variables
U = m.addVar(vtype=GRB.INTEGER, name="Undergraduate_Students")
G = m.addVar(vtype=GRB.INTEGER, name="Graduate_Students")

# Set the objective function
m.setObjective(100*U + 300*G, GRB.MINIMIZE)

# Add constraints
m.addConstr(U + G >= 50, "Total_Students")
m.addConstr(G >= 10, "Minimum_Graduate_Students")
m.addConstr(G >= (1/3)*U, "Graduate_vs_Undergraduate")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Undergraduate Students: {U.x}")
    print(f"Graduate Students: {G.x}")
    print(f"Total Weekly Wages: ${100*U.x + 300*G.x}")
else:
    print("No optimal solution found")
