
from gurobi import *

# Create a new model
m = Model("ResearchLab")

# Define the variables
U = m.addVar(lb=0, vtype=GRB.INTEGER, name="UndergraduateStudents")
G = m.addVar(lb=0, vtype=GRB.INTEGER, name="GraduateStudents")

# Objective function: Minimize weekly wages
m.setObjective(100*U + 300*G, GRB.MINIMIZE)

# Constraints
m.addConstr(U + G >= 50, name="TotalStudents")
m.addConstr(G >= 10, name="MinGraduateStudents")
m.addConstr(G >= U/3, name="GraduateUndergraduateRatio")

# Optimize the model
m.optimize()

# Print the status of the optimization
print("Optimization Status:", m.status)

# If the model is optimized, print the solution
if m.status == GRB.OPTIMAL:
    print("Undergraduate Students:", U.varValue)
    print("Graduate Students:", G.varValue)
    print("Minimum Weekly Wages: $", 100*U.varValue + 300*G.varValue)
else:
    print("The model is infeasible.")
