
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("spice_cabinet_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="small_cabinets") # Number of small cabinets
y = m.addVar(vtype=GRB.INTEGER, name="large_cabinets") # Number of large cabinets

# Set objective function
m.setObjective(30*x + 40*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x + 8*y <= 200, "space_constraint")
m.addConstr(70*x + 120*y <= 1400, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of small cabinets (x): {x.x}")
    print(f"Number of large cabinets (y): {y.x}")
    print(f"Maximum number of seasonings/spices: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

