
from gurobipy import *

# Create a model
m = Model("Cabinet_Optimization")

# Define variables
x_s = m.addVar(vtype=GRB.INTEGER, name="small_cabinets")
x_l = m.addVar(vtype=GRB.INTEGER, name="large_cabinets")

# Objective function: Maximize the total number of seasonings and spices stored
m.setObjective(30*x_s + 40*x_l, GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x_s + 8*x_l <= 200, name="space_constraint")
m.addConstr(70*x_s + 120*x_l <= 1400, name="budget_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x_s.x} small cabinets")
    print(f"Buy {x_l.x} large cabinets")
    print(f"Maximum seasonings and spices that can be stored: {30*x_s.x + 40*x_l.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
