
import gurobi

def solve_cabinet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="small_cabinets", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="large_cabinets", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 30x + 40y
    model.setObjective(30*x + 40*y, gurobi.GRB.MAXIMIZE)

    # Space constraint: 4x + 8y <= 200
    model.addConstr(4*x + 8*y <= 200, name="space_constraint")

    # Budget constraint: 70x + 120y <= 1400
    model.addConstr(70*x + 120*y <= 1400, name="budget_constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum seasonings and spices: {30*x.varValue + 40*y.varValue}")
    else:
        print("No optimal solution found")

solve_cabinet_problem()
