
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Omega Seafood")

# Create variables
x = m.addVar(lb=0, name="Indian_Ocean_Days")
y = m.addVar(lb=0, name="Arctic_Ocean_Days")

# Set objective function
m.setObjective(6000 * x + 9000 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(3.4 * x + 6 * y >= 20, "Fish_Constraint")
m.addConstr(2.2 * x + 5 * y >= 12, "Crab_Constraint")
m.addConstr(1.5 * x + 3 * y >= 10, "Shrimp_Constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Indian Ocean Days: {x.x}")
    print(f"Arctic Ocean Days: {y.x}")
    print(f"Total Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

