
from gurobipy import *

# Create a model
m = Model("Seafood_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Indian_Ocean_Days")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Arctic_Ocean_Days")

# Set the objective function: minimize total operational cost
m.setObjective(6000*x + 9000*y, GRB.MINIMIZE)

# Add constraints for each seafood product demand
m.addConstr(3.4*x + 6*y >= 20, "Fish_Demand")
m.addConstr(2.2*x + 5*y >= 12, "Crab_Demand")
m.addConstr(1.5*x + 3*y >= 10, "Shrimp_Demand")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Total operational cost: ${6000*x.x + 9000*y.x:.2f}")
else:
    print("No optimal solution found")
