
import gurobipy as gp

# Create a new model
m = gp.Model("omega_seafood")

# Decision variables
x = m.addVar(name="indian_ocean_days", lb=0, ub=7, vtype=gp.GRB.INTEGER)  # Days in Indian ocean
y = m.addVar(name="arctic_ocean_days", lb=0, ub=7, vtype=gp.GRB.INTEGER)  # Days in Arctic ocean

# Objective function: Minimize cost
m.setObjective(6000*x + 9000*y, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(3.4*x + 6*y >= 20, name="fish_requirement")
m.addConstr(2.2*x + 5*y >= 12, name="crab_requirement")
m.addConstr(1.5*x + 3*y >= 10, name="shrimp_requirement")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Indian Ocean = {x.varValue} days, Arctic Ocean = {y.varValue} days")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
