
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tree_planting")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oak_acres")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="elm_acres")

# Set objective function
m.setObjective(1000*x + 1200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "land_constraint")
m.addConstr(x >= 50, "min_oak")
m.addConstr(y >= 70, "min_elm")
m.addConstr(y <= 2*x, "elm_oak_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of oak trees")
    print(f"Plant {y.x} acres of elm trees")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

