
from gurobipy import *

# Create a new model
m = Model("Tree_Farming")

# Define the decision variables
O = m.addVar(name='oak', lb=50)  # At least 50 acres of oak trees
E = m.addVar(name='elm', lb=70)  # At least 70 acres of elm trees

# Define the objective function: Maximize profit
m.setObjective(1000*O + 1200*E, GRB.MAXIMIZE)

# Add constraints
m.addConstr(O + E <= 300, name='total_land')  # Total land constraint
m.addConstr(E <= 2*O, name='elm_to_oak_ratio')  # Elm to oak ratio constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Oak trees: {O.x} acres")
    print(f"Elm trees: {E.x} acres")
    print(f"Maximum profit: ${1000*O.x + 1200*E.x}")
else:
    print("No optimal solution found.")
