
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=50, name="oak_acres")  # At least 50 acres of oak
    y = model.addVar(lb=70, name="elm_acres")  # At least 70 acres of elm

    # Objective function: Maximize profit
    model.setObjective(1000 * x + 1200 * y, gurobi.GRB.MAXIMIZE)

    # Total land constraint
    model.addConstr(x + y <= 300, name="total_land")

    # Elm vs. Oak trees constraint
    model.addConstr(y <= 2 * x, name="elm_vs_oak")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of oak trees: {x.varValue}")
        print(f"Optimal acres of elm trees: {y.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
