
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("electronics_stock")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="monitors") # Number of monitors
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="gaming_stations") # Number of gaming stations

# Set objective function
m.setObjective(40*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x + 12*y <= 150, "space_constraint")
m.addConstr(3*y - 2*x >= 0, "marketing_constraint")
m.addConstr(180*x + 260*y <= 4000, "capital_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Number of Monitors: {x.x:.2f}")
    print(f"Number of Gaming Stations: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

