
from gurobipy import *

# Create a new model
model = Model("Electronics_Store_Profit_Maximization")

# Define the decision variables
M = model.addVar(vtype=GRB.INTEGER, name="Monitors")
G = model.addVar(vtype=GRB.INTEGER, name="Gaming_Stations")

# Set the objective function
model.setObjective(40*M + 80*G, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8*M + 12*G <= 150, "Floor_Space_Constraint")
model.addConstr(G >= (2/3)*M, "Marketing_Requirement_Constraint")
model.addConstr(180*M + 260*G <= 4000, "Capital_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Monitors to stock: {M.x}")
    print(f"Gaming Stations to stock: {G.x}")
    print(f"Maximum Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
