
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    M = model.addVar(lb=0, name="Monitors")
    G = model.addVar(lb=0, name="Gaming_Stations")

    # Objective function: Maximize profit
    model.setObjective(40 * M + 80 * G, gurobi.GRB.MAXIMIZE)

    # Floor space constraint
    model.addConstr(8 * M + 12 * G <= 150, name="Floor_Space")

    # Marketing requirement constraint
    model.addConstr(M - 1.5 * G <= 0, name="Marketing_Requirement")

    # Capital constraint
    model.addConstr(180 * M + 260 * G <= 4000, name="Capital_Constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Monitors: {M.varValue}, Gaming Stations: {G.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
