
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Natural_Pharmacy")

# Create decision variables
A = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Alpha") # Allowing fractional bottles for now
B = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Beta")

# Set objective function
model.setObjective(4*A + 6*B, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15*A + 25*B <= 2000, "Extract_Constraint")
model.addConstr(A >= 3*B, "Demand_Constraint")
model.addConstr(B >= 10, "Min_Beta_Constraint")

# Optimize the model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print the optimal solution
    print(f"Optimal Production Plan:")
    print(f"Alpha: {A.x}")
    print(f"Beta: {B.x}")
    print(f"Optimal Profit: ${model.objVal}")

    # Round down to get integer bottle counts
    A_int = int(A.x)
    B_int = int(B.x)

    # Recalculate profit with integer values
    profit_int = 4 * A_int + 6 * B_int

    print(f"\nInteger Production Plan (Rounded Down):")
    print(f"Alpha: {A_int}")
    print(f"Beta: {B_int}")
    print(f"Integer Profit: ${profit_int}")

