
from gurobipy import *

# Create a model
m = Model("Natural Pharmacy Problem")

# Define decision variables
A = m.addVar(name='Alpha', vtype=GRB.INTEGER)
B = m.addVar(name='Beta', vtype=GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(4*A + 6*B, GRB.MAXIMIZE)

# Constraints
m.addConstr(15*A + 25*B <= 2000, name='Extract Limit')
m.addConstr(A >= 3*B, name='Demand Constraint')
m.addConstr(B >= 10, name='Minimum Beta')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {A.x} bottles of Alpha and {B.x} bottles of Beta.")
else:
    print("No optimal solution found.")

