
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="Alpha", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="Beta", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(4 * x + 6 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * x + 25 * y <= 2000, name="extract_limitation")
    model.addConstr(x >= 3 * y, name="demand_constraint")
    model.addConstr(y >= 10, name="min_beta_production")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Alpha = {x.varValue}, Beta = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
