
from gurobipy import *

# Create a new model
m = Model("Sandwich_Problem")

# Define the decision variables
x = m.addVar(lb=45, ub=80, name="Peanut_Butter_Sandwiches")  # Minimum and maximum bounds for peanut butter sandwiches
y = m.addVar(lb=65, ub=100, name="Chocolate_Spread_Sandwiches")  # Minimum and maximum bounds for chocolate spread sandwiches

# Set the objective function: Maximize profit
m.setObjective(3*x + 2*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 150, "Total_Sandwiches")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peanut Butter Sandwiches: {x.x}")
    print(f"Chocolate Spread Sandwiches: {y.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
